package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSetting;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignSettingMap extends ModelBeanMap<CpmBannerCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public CpmBannerCampaignSettingMap() {
        super();
        setBean(new CpmBannerCampaignSetting());
    }

    public CpmBannerCampaignSettingMap(CpmBannerCampaignSetting cpmBannerCampaignSetting) {
        super();
        setBean(cpmBannerCampaignSetting);
    }

    public CpmBannerCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignSettingMap withOption(CpmBannerCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public CpmBannerCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
