package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignStrategyAddMap extends ModelBeanMap<CpmBannerCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public CpmBannerCampaignStrategyAddMap() {
        super();
        setBean(new CpmBannerCampaignStrategyAdd());
    }

    public CpmBannerCampaignStrategyAddMap(CpmBannerCampaignStrategyAdd cpmBannerCampaignStrategyAdd) {
        super();
        setBean(cpmBannerCampaignStrategyAdd);
    }

    public CpmBannerCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignStrategyAddMap withSearch(
            CpmBannerCampaignSearchStrategyAddMap cpmBannerCampaignSearchStrategyAddMap)
    {
        CpmBannerCampaignSearchStrategyAdd cpmBannerCampaignSearchStrategyAdd =
                ((cpmBannerCampaignSearchStrategyAddMap == null) ? null
                        : (CpmBannerCampaignSearchStrategyAdd) (cpmBannerCampaignSearchStrategyAddMap.getBean()));
        this.put(SEARCH, cpmBannerCampaignSearchStrategyAdd);
        return this;
    }

    public CpmBannerCampaignStrategyAddMap withNetwork(
            CpmBannerCampaignNetworkStrategyAddMap cpmBannerCampaignNetworkStrategyAddMap)
    {
        CpmBannerCampaignNetworkStrategyAdd cpmBannerCampaignNetworkStrategyAdd =
                ((cpmBannerCampaignNetworkStrategyAddMap == null) ? null
                        : (CpmBannerCampaignNetworkStrategyAdd) (cpmBannerCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, cpmBannerCampaignNetworkStrategyAdd);
        return this;
    }

    public CpmBannerCampaignStrategyAddMap defaultCpmBannerCampaignStrategy() {
        return this
                .withSearch(new CpmBannerCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF))
                .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM));
    }
}
