package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by hmepas on 20.09.18.
 */
public class CpmBannerCampaignStrategyMap extends ModelBeanMap<CpmBannerCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public CpmBannerCampaignStrategyMap() {
        super();
        setBean(new CpmBannerCampaignStrategy());
    }

    public CpmBannerCampaignStrategyMap(CpmBannerCampaignStrategy cpmBannerCampaignStrategy) {
        super();
        setBean(cpmBannerCampaignStrategy);
    }

    public CpmBannerCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignStrategyMap withSearch(
            CpmBannerCampaignSearchStrategyMap cpmBannerCampaignSearchStrategyMap)
    {
        CpmBannerCampaignSearchStrategy cpmBannerCampaignSearchStrategyUpdate =
                ((cpmBannerCampaignSearchStrategyMap == null) ? null
                        : (CpmBannerCampaignSearchStrategy) (cpmBannerCampaignSearchStrategyMap.getBean()));
        this.put(SEARCH, cpmBannerCampaignSearchStrategyUpdate);
        return this;
    }

    public CpmBannerCampaignStrategyMap withNetwork(
            CpmBannerCampaignNetworkStrategyMap cpmBannerCampaignNetworkStrategyMap)
    {
        CpmBannerCampaignNetworkStrategy cpmBannerCampaignNetworkStrategy =
                ((cpmBannerCampaignNetworkStrategyMap == null) ? null
                        : (CpmBannerCampaignNetworkStrategy) (cpmBannerCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, cpmBannerCampaignNetworkStrategy);
        return this;
    }

    public CpmBannerCampaignStrategyMap defaultCpmBannerCampaignStrategy() {
        return this
                .withSearch(new CpmBannerCampaignSearchStrategyMap()
                        .withBiddingStrategyType(CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF))
                .withNetwork(new CpmBannerCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM));
    }
}
