package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignStrategy;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignUpdateItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by hmepas on 20.09.18.
 */
public class CpmBannerCampaignUpdateItemMap extends CpmBannerCampaignBaseMap<CpmBannerCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;

    public CpmBannerCampaignUpdateItemMap() {
        super();
        setBean(new CpmBannerCampaignUpdateItem());
    }

    public CpmBannerCampaignUpdateItemMap(CpmBannerCampaignUpdateItem cpmBannerCampaignUpdateItem) {
        super();
        setBean(cpmBannerCampaignUpdateItem);
    }

    public CpmBannerCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignUpdateItemMap withBiddingStrategy(
            CpmBannerCampaignStrategyMap cpmBannerCampaignStrategyMap)
    {
        CpmBannerCampaignStrategy cpmBannerCampaignStrategyUpdate =
                ((cpmBannerCampaignStrategyMap == null) ? null
                        : (CpmBannerCampaignStrategy) (cpmBannerCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, cpmBannerCampaignStrategyUpdate);
        return this;
    }

    public CpmBannerCampaignUpdateItemMap withSettings(CpmBannerCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public CpmBannerCampaignUpdateItemMap defaultCpmBannerCampaign() {
        return this.withBiddingStrategy(new CpmBannerCampaignStrategyMap().defaultCpmBannerCampaignStrategy());
    }
}
