package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignAddItem;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsArray;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignAddItemMap extends ModelBeanMap<DynamicTextCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String COUNTER_IDS = "counterIds";
    public static final String PRIORITY_GOALS = "priorityGoals";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;

    public DynamicTextCampaignAddItemMap() {
        super();
        setBean(new DynamicTextCampaignAddItem());
    }

    public DynamicTextCampaignAddItemMap(DynamicTextCampaignAddItem dynamicTextCampaignAddItem) {
        super();
        setBean(dynamicTextCampaignAddItem);
    }

    public DynamicTextCampaignAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignAddItemMap withBiddingStrategy(
            DynamicTextCampaignStrategyAddMap dynamicTextCampaignStrategyAddMap)
    {
        DynamicTextCampaignStrategyAdd dynamicTextCampaignStrategyAdd =
                ((dynamicTextCampaignStrategyAddMap == null) ? null
                        : (DynamicTextCampaignStrategyAdd) (dynamicTextCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, dynamicTextCampaignStrategyAdd);
        return this;
    }

    public DynamicTextCampaignAddItemMap withSettings(DynamicTextCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public DynamicTextCampaignAddItemMap defaultDynamicTextCampaign() {
        return this.withBiddingStrategy(new DynamicTextCampaignStrategyAddMap().defaultDynamicTextCampaignStrategy());
    }

    public DynamicTextCampaignAddItemMap withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        return this.put(COUNTER_IDS, counterIds);
    }

    public DynamicTextCampaignAddItemMap withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public DynamicTextCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoals =
                (PriorityGoalsArray) ((priorityGoalsArrayMap == null) ? null : priorityGoalsArrayMap.getBean());
        return this.put(PRIORITY_GOALS, priorityGoals);
    }

    public DynamicTextCampaignAddItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        PriorityGoalsArrayMap priorityGoalsArray =
                (priorityGoals == null) ? null : new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(priorityGoalsArray);
    }

    public DynamicTextCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }
}
