package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignNetworkStrategyAddMap extends ModelBeanMap<DynamicTextCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public DynamicTextCampaignNetworkStrategyAddMap() {
        super();
        setBean(new DynamicTextCampaignNetworkStrategyAdd());
    }

    public DynamicTextCampaignNetworkStrategyAddMap(
            DynamicTextCampaignNetworkStrategyAdd dynamicTextCampaignNetworkStrategyAdd)
    {
        super();
        setBean(dynamicTextCampaignNetworkStrategyAdd);
    }

    public DynamicTextCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignNetworkStrategyAddMap withBiddingStrategyType(
            DynamicTextCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public DynamicTextCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
