package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignNetworkStrategyMap extends ModelBeanMap<DynamicTextCampaignNetworkStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public DynamicTextCampaignNetworkStrategyMap() {
        super();
        setBean(new DynamicTextCampaignNetworkStrategy());
    }

    public DynamicTextCampaignNetworkStrategyMap(
            DynamicTextCampaignNetworkStrategy dynamicTextCampaignNetworkStrategy)
    {
        super();
        setBean(dynamicTextCampaignNetworkStrategy);
    }

    public DynamicTextCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignNetworkStrategyMap withBiddingStrategyType(
            DynamicTextCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public DynamicTextCampaignNetworkStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
