package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignSearchStrategyAddMap extends DynamicTextCampaignStrategyAddBaseMap<DynamicTextCampaignSearchStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public DynamicTextCampaignSearchStrategyAddMap() {
        super();
        setBean(new DynamicTextCampaignSearchStrategyAdd());
    }

    public DynamicTextCampaignSearchStrategyAddMap(
            DynamicTextCampaignSearchStrategyAdd dynamicTextCampaignSearchStrategyAdd)
    {
        super();
        setBean(dynamicTextCampaignSearchStrategyAdd);
    }

    public DynamicTextCampaignSearchStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignSearchStrategyAddMap withBiddingStrategyType(
            DynamicTextCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultHighestPosition() {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaAddMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiAddMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
