package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSetting;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignSettingMap extends ModelBeanMap<DynamicTextCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public DynamicTextCampaignSettingMap() {
        super();
        setBean(new DynamicTextCampaignSetting());
    }

    public DynamicTextCampaignSettingMap(DynamicTextCampaignSetting dynamicTextCampaignSetting) {
        super();
        setBean(dynamicTextCampaignSetting);
    }

    public DynamicTextCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignSettingMap withOption(DynamicTextCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public DynamicTextCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
