package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpa;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpc;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageRoi;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicks;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumConversionRate;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackage;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignStrategyBaseMap<T> extends ModelBeanMap<DynamicTextCampaignStrategyBaseMap> {

    public static final String WB_MAXIMUM_CLICKS = "wbMaximumClicks";
    public static final String WB_MAXIMUM_CONVERSION_RATE = "wbMaximumConversionRate";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String WEEKLY_CLICK_PACKAGE = "weeklyClickPackage";
    public static final String AVERAGE_ROI = "averageRoi";

    public DynamicTextCampaignStrategyBaseMap() {
        super();
    }

    public T withWbMaximumClicks(StrategyMaximumClicksMap paramsMap) {
        StrategyMaximumClicks strategyMaximumClicks =
                ((paramsMap == null) ? null : (StrategyMaximumClicks) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CLICKS, strategyMaximumClicks);
        return (T) this;
    }

    public T withWbMaximumConversionRate(StrategyMaximumConversionRateMap paramsMap) {
        StrategyMaximumConversionRate params =
                ((paramsMap == null) ? null : (StrategyMaximumConversionRate) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CONVERSION_RATE, params);
        return (T) this;
    }

    public T withAverageCpc(StrategyAverageCpcMap paramsMap) {
        StrategyAverageCpc params =
                ((paramsMap == null) ? null : (StrategyAverageCpc) (paramsMap.getBean()));
        this.put(AVERAGE_CPC, params);
        return (T) this;
    }

    public T withAverageCpa(StrategyAverageCpaMap paramsMap) {
        StrategyAverageCpa params =
                ((paramsMap == null) ? null : (StrategyAverageCpa) (paramsMap.getBean()));
        this.put(AVERAGE_CPA, params);
        return (T) this;
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageMap paramsMap) {
        StrategyWeeklyClickPackage params =
                ((paramsMap == null) ? null : (StrategyWeeklyClickPackage) (paramsMap.getBean()));
        this.put(WEEKLY_CLICK_PACKAGE, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiMap paramsMap) {
        StrategyAverageRoi params =
                ((paramsMap == null) ? null : (StrategyAverageRoi) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }
}
