package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignStrategy;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsUpdateSetting;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignUpdateItemMap extends DynamicTextCampaignBaseMap<DynamicTextCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public DynamicTextCampaignUpdateItemMap() {
        super();
        setBean(new DynamicTextCampaignUpdateItem());
    }

    public DynamicTextCampaignUpdateItemMap(DynamicTextCampaignUpdateItem dynamicTextCampaignUpdateItem) {
        super();
        setBean(dynamicTextCampaignUpdateItem);
    }

    public DynamicTextCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignUpdateItemMap withBiddingStrategy(
            DynamicTextCampaignStrategyMap dynamicTextCampaignStrategyMap)
    {
        DynamicTextCampaignStrategy dynamicTextCampaignStrategy =
                ((dynamicTextCampaignStrategyMap == null) ? null
                        : (DynamicTextCampaignStrategy) (dynamicTextCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, dynamicTextCampaignStrategy);
        return this;
    }

    public DynamicTextCampaignUpdateItemMap withSettings(DynamicTextCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public DynamicTextCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateSettingMap priorityGoalsUpdateSettingMap) {
        PriorityGoalsUpdateSetting priorityGoalsUpdateSetting = (PriorityGoalsUpdateSetting)
                ((priorityGoalsUpdateSettingMap == null) ? null
                        : priorityGoalsUpdateSettingMap.getBean());
        JAXBElement<PriorityGoalsUpdateSetting> jaxbElement =
                new ObjectFactory().createDynamicTextCampaignUpdateItemPriorityGoals(priorityGoalsUpdateSetting);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public DynamicTextCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateItemMap... priorityGoalsUpdate) {
        PriorityGoalsUpdateSettingMap priorityUpdateSettingMap =
                (priorityGoalsUpdate == null) ? null : new PriorityGoalsUpdateSettingMap().withItems(priorityGoalsUpdate);
        return this.withPriorityGoals(priorityUpdateSettingMap);
    }
}
