package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignAddItem;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignAddItemMap extends ModelBeanMap<MobileAppCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public MobileAppCampaignAddItemMap() {
        super();
        setBean(new MobileAppCampaignAddItem());
    }

    public MobileAppCampaignAddItemMap(MobileAppCampaignAddItem mobileAppCampaignAddItem) {
        super();
        setBean(mobileAppCampaignAddItem);
    }

    public MobileAppCampaignAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignAddItemMap withBiddingStrategy(
            MobileAppCampaignStrategyAddMap MobileAppCampaignStrategyAddMap)
    {
        MobileAppCampaignStrategyAdd mobileAppCampaignStrategy =
                ((MobileAppCampaignStrategyAddMap == null) ? null
                        : (MobileAppCampaignStrategyAdd) (MobileAppCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, mobileAppCampaignStrategy);
        return this;
    }

    public MobileAppCampaignAddItemMap withSettings(MobileAppCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public MobileAppCampaignAddItemMap defaultMobileAppCampaign() {
        return this.withBiddingStrategy(new MobileAppCampaignStrategyAddMap().defaultMobileAppCampaignStrategy());
    }
}
