package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignStrategy;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignGetItemMap extends ModelBeanMap<MobileAppCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public MobileAppCampaignGetItemMap() {
        setBean(new MobileAppCampaignGetItem());
    }

    public MobileAppCampaignGetItemMap(MobileAppCampaignGetItem mobileAppCampaignGetItem) {
        super();
        setBean(mobileAppCampaignGetItem);
    }

    public MobileAppCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignGetItemMap withBiddingStrategy(
            MobileAppCampaignStrategyMap MobileAppCampaignStrategyAddMap)
    {
        MobileAppCampaignStrategy mobileAppCampaignStrategy =
                ((MobileAppCampaignStrategyAddMap == null) ? null
                        : (MobileAppCampaignStrategy) (MobileAppCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, mobileAppCampaignStrategy);
        return this;
    }

    public MobileAppCampaignGetItemMap withSettings(MobileAppCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public MobileAppCampaignGetItemMap defaultMobileAppCampaign() {
        return this.withBiddingStrategy(new MobileAppCampaignStrategyMap().defaultMobileAppCampaignStrategy());
    }
}
