package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.StrategyNetworkDefault;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class MobileAppCampaignNetworkStrategyMap extends MobileAppCampaignStrategyBaseMap<MobileAppCampaignNetworkStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String NETWORK_DEFAULT = "networkDefault";

    public MobileAppCampaignNetworkStrategyMap() {
        super();
        setBean(new MobileAppCampaignNetworkStrategy());
    }

    public MobileAppCampaignNetworkStrategyMap(MobileAppCampaignNetworkStrategy mobileAppCampaignNetworkStrategy) {
        super();
        setBean(mobileAppCampaignNetworkStrategy);
    }

    public MobileAppCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignNetworkStrategyMap withNetworkDefault(StrategyNetworkDefaultMap strategyNetworkDefaultMap) {
        StrategyNetworkDefault networkDefaultParams =
                ((strategyNetworkDefaultMap == null) ? null
                        : (StrategyNetworkDefault) (strategyNetworkDefaultMap.getBean()));
        this.put(NETWORK_DEFAULT, networkDefaultParams);
        return this;
    }

    public MobileAppCampaignNetworkStrategyMap withBiddingStrategyType(
            MobileAppCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public MobileAppCampaignNetworkStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public MobileAppCampaignNetworkStrategyMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public MobileAppCampaignNetworkStrategyMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultMap());
    }

    public MobileAppCampaignNetworkStrategyMap defaultNetworkDefaultWithLimitPercent() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultMap()
                        .defaultStrategyNetworkDefault());
    }

    public MobileAppCampaignNetworkStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public MobileAppCampaignNetworkStrategyMap defaultWbMaximumAppInstalls(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsMap()
                        .defaultStrategyMaximumAppInstalls(currency));
    }

    public MobileAppCampaignNetworkStrategyMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public MobileAppCampaignNetworkStrategyMap defaultAverageCpi(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI)
                .withAverageCpi(new StrategyAverageCpiMap()
                        .defaultStrategyAverageCpi(currency));
    }

}
