package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpiAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumAppInstallsAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicksAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackageAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignStrategyAddBaseMap<T> extends ModelBeanMap<MobileAppCampaignStrategyAddBaseMap> {
    public static final String WB_MAXIMUM_CLICKS = "wbMaximumClicks";
    public static final String WB_MAXIMUM_APP_INSTALLS = "wbMaximumAppInstalls";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String AVERAGE_CPI = "averageCpi";
    public static final String WEEKLY_CLICK_PACKAGE = "weeklyClickPackage";

    public MobileAppCampaignStrategyAddBaseMap() {
        super();
    }

    public T withWbMaximumClicks(StrategyMaximumClicksAddMap paramsMap) {
        StrategyMaximumClicksAdd strategyMaximumClicks =
                ((paramsMap == null) ? null : (StrategyMaximumClicksAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CLICKS, strategyMaximumClicks);
        return (T) this;
    }

    public T withWbMaximumAppInstalls(StrategyMaximumAppInstallsAddMap paramsMap) {
        StrategyMaximumAppInstallsAdd params =
                ((paramsMap == null) ? null : (StrategyMaximumAppInstallsAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_APP_INSTALLS, params);
        return (T) this;
    }

    public T withAverageCpc(StrategyAverageCpcAddMap paramsMap) {
        StrategyAverageCpcAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC, params);
        return (T) this;
    }

    public T withAverageCpi(StrategyAverageCpiAddMap paramsMap) {
        StrategyAverageCpiAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpiAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPI, params);
        return (T) this;
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageAddMap paramsMap) {
        StrategyWeeklyClickPackageAdd params =
                ((paramsMap == null) ? null : (StrategyWeeklyClickPackageAdd) (paramsMap.getBean()));
        this.put(WEEKLY_CLICK_PACKAGE, params);
        return (T) this;
    }
}
