package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignStrategyAddMap extends ModelBeanMap<MobileAppCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public MobileAppCampaignStrategyAddMap() {
        super();
        setBean(new MobileAppCampaignStrategyAdd());
    }

    public MobileAppCampaignStrategyAddMap(MobileAppCampaignStrategyAdd mobileAppCampaignStrategy) {
        super();
        setBean(mobileAppCampaignStrategy);
    }

    public MobileAppCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignStrategyAddMap withSearch(
            MobileAppCampaignSearchStrategyAddMap MobileAppCampaignSearchStrategyAddMap)
    {
        MobileAppCampaignSearchStrategyAdd mobileAppCampaignSearchStrategy =
                ((MobileAppCampaignSearchStrategyAddMap == null) ? null
                        : (com.yandex.direct.api.v5.campaignsext.MobileAppCampaignSearchStrategyAdd) (MobileAppCampaignSearchStrategyAddMap
                                .getBean()));
        this.put(SEARCH, mobileAppCampaignSearchStrategy);
        return this;
    }

    public MobileAppCampaignStrategyAddMap withNetwork(
            MobileAppCampaignNetworkStrategyAddMap MobileAppCampaignNetworkStrategyAddMap)
    {
        MobileAppCampaignNetworkStrategyAdd mobileAppCampaignNetworkStrategy =
                ((MobileAppCampaignNetworkStrategyAddMap == null) ? null
                        : (MobileAppCampaignNetworkStrategyAdd) (MobileAppCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, mobileAppCampaignNetworkStrategy);
        return this;
    }

    public MobileAppCampaignStrategyAddMap defaultMobileAppCampaignStrategy() {
        return this
                .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
