package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpc;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpi;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumAppInstalls;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicks;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackage;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class MobileAppCampaignStrategyBaseMap<T> extends ModelBeanMap<MobileAppCampaignStrategyBaseMap> {
    public static final String WB_MAXIMUM_CLICKS = "wbMaximumClicks";
    public static final String WB_MAXIMUM_APP_INSTALLS = "wbMaximumAppInstalls";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String AVERAGE_CPI = "averageCpi";
    public static final String WEEKLY_CLICK_PACKAGE = "weeklyClickPackage";

    public MobileAppCampaignStrategyBaseMap() {
        super();
    }

    public T withWbMaximumClicks(StrategyMaximumClicksMap paramsMap) {
        StrategyMaximumClicks strategyMaximumClicks =
                ((paramsMap == null) ? null : (StrategyMaximumClicks) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CLICKS, strategyMaximumClicks);
        return (T) this;
    }

    public T withWbMaximumAppInstalls(StrategyMaximumAppInstallsMap paramsMap) {
        StrategyMaximumAppInstalls params =
                ((paramsMap == null) ? null : (StrategyMaximumAppInstalls) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_APP_INSTALLS, params);
        return (T) this;
    }

    public T withAverageCpc(StrategyAverageCpcMap paramsMap) {
        StrategyAverageCpc params =
                ((paramsMap == null) ? null : (StrategyAverageCpc) (paramsMap.getBean()));
        this.put(AVERAGE_CPC, params);
        return (T) this;
    }

    public T withAverageCpi(StrategyAverageCpiMap paramsMap) {
        StrategyAverageCpi params =
                ((paramsMap == null) ? null : (StrategyAverageCpi) (paramsMap.getBean()));
        this.put(AVERAGE_CPI, params);
        return (T) this;
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageMap paramsMap) {
        StrategyWeeklyClickPackage params =
                ((paramsMap == null) ? null : (StrategyWeeklyClickPackage) (paramsMap.getBean()));
        this.put(WEEKLY_CLICK_PACKAGE, params);
        return (T) this;
    }
}
