package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.PriorityGoalsArray;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by liosha on 21.12.18.
 */
public class PriorityGoalsArrayMap extends ModelBeanMap<PriorityGoalsArrayMap> {

    public static final String PRIORITY_GOALS_ARRAY_ITEMS = "items";

    public static final int PRIORITY_GOALS_IN_REQUEST_LIMIT = 100;

    public PriorityGoalsArrayMap() {
        super();
        setBean(new PriorityGoalsArray());
    }

    public PriorityGoalsArrayMap(PriorityGoalsArray priorityGoalsArray) {
        super();
        setBean(priorityGoalsArray);
    }

    public PriorityGoalsArrayMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriorityGoalsArrayMap withItems(PriorityGoalsItemMap... items) {
        this.put(PRIORITY_GOALS_ARRAY_ITEMS, (items == null) ? null : convert(items, new BeanMapToBeanConverter()));
        return this;
    }
}
