package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.PriorityGoalsUpdateSetting;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by liosha on 21.12.18.
 */
public class PriorityGoalsUpdateSettingMap extends ModelBeanMap<PriorityGoalsUpdateSettingMap> {

    public static final String PRIORITY_GOALS_UPDATE_SETTINGS_ITEMS = "items";

    public static final int PRIORITY_GOALS_IN_REQUEST_LIMIT = 100;

    public PriorityGoalsUpdateSettingMap() {
        super();
        setBean(new PriorityGoalsUpdateSetting());
    }

    public PriorityGoalsUpdateSettingMap(PriorityGoalsUpdateSetting priorityGoalsUpdateSetting) {
        super();
        setBean(priorityGoalsUpdateSetting);
    }

    public PriorityGoalsUpdateSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriorityGoalsUpdateSettingMap withItems(PriorityGoalsUpdateItemMap... items) {
        this.put(PRIORITY_GOALS_UPDATE_SETTINGS_ITEMS, (items == null) ? null : convert(items, new BeanMapToBeanConverter()));
        return this;
    }
}
