package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.RelevantKeywordsModeEnum;
import com.yandex.direct.api.v5.campaignsext.RelevantKeywordsSetting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class RelevantKeywordsSettingMap extends ModelBeanMap<RelevantKeywordsSettingMap> {

    public static final String BUDGET_PERCENT = "budgetPercent";
    public static final String MODE = "mode";
    public static final String OPTIMIZE_GOAL_ID = "optimizeGoalId";

    public RelevantKeywordsSettingMap() {
        super();
        setBean(new RelevantKeywordsSetting());
    }

    public RelevantKeywordsSettingMap(RelevantKeywordsSetting relevantKeywordsSetting) {
        super();
        setBean(relevantKeywordsSetting);
    }

    public RelevantKeywordsSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RelevantKeywordsSettingMap withBudgetPercent(Integer budgetPercent) {
        this.put(BUDGET_PERCENT, budgetPercent);
        return this;
    }

    public RelevantKeywordsSettingMap withMode(RelevantKeywordsModeEnum mode) {
        this.put(MODE, mode);
        return this;
    }

    public RelevantKeywordsSettingMap withOptimizeGoalId(Long optimizeGoalId) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createRelevantKeywordsSettingOptimizeGoalId(optimizeGoalId);
        this.put(OPTIMIZE_GOAL_ID, jaxbElement);
        return this;
    }

}
