package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.SharedAccountFundsParam;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 26.08.15.
 */
public class SharedAccountFundsParamMap extends ModelBeanMap<SharedAccountFundsParamMap> {
    public static final String REFUND = "refund";
    public static final String SPEND = "spend";

    public SharedAccountFundsParamMap() {
        super();
        setBean(new SharedAccountFundsParam());
    }

    public SharedAccountFundsParamMap(SharedAccountFundsParam sharedAccountFundsParam) {
        super();
        setBean(sharedAccountFundsParam);
    }

    public SharedAccountFundsParamMap withRefund(Long refund) {
        this.put(REFUND, refund);
        return this;
    }

    public SharedAccountFundsParamMap withSpend(Long spend) {
        this.put(SPEND, spend);
        return this;
    }
}
