package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.PriorityGoalsArray;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignAddItem;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignStrategyAdd;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;
import static ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignBaseMap.ATTRIBUTION_MODEL;

public class SmartCampaignAddItemMap extends ModelBeanMap<SmartCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String COUNTER_ID = "counterId";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public SmartCampaignAddItemMap() {
        super();
        setBean(new SmartCampaignAddItem());
    }

    public SmartCampaignAddItemMap withSettings(SmartCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public SmartCampaignAddItemMap defaultSmartCampaign() {
        return this.withBiddingStrategy(new SmartCampaignStrategyAddMap().defaultSmartCampaignStrategy());
    }

    public SmartCampaignAddItemMap withBiddingStrategy(
            SmartCampaignStrategyAddMap smartCampaignStrategyAddMap) {
        SmartCampaignStrategyAdd dynamicTextCampaignStrategyAdd =
                ((smartCampaignStrategyAddMap == null) ? null
                        : (SmartCampaignStrategyAdd) (smartCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, dynamicTextCampaignStrategyAdd);
        return this;
    }

    public SmartCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public SmartCampaignAddItemMap withCounterId(Long counterId) {
        this.put(COUNTER_ID, counterId);
        return this;
    }

    public SmartCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoals =
                (PriorityGoalsArray) ((priorityGoalsArrayMap == null) ? null : priorityGoalsArrayMap.getBean());
        return this.put(PRIORITY_GOALS, priorityGoals);
    }
}
