package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignBaseMap<T> extends ModelBeanMap<SmartCampaignBaseMap> {

    public static final String COUNTER_ID = "counterId";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public SmartCampaignBaseMap() {
        super();
    }

    public T withCounterId(Long counterId) {
        this.put(COUNTER_ID, counterId);
        return (T) this;
    }

    public T withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return (T) this;
    }
}
