package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.SmartCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignNetworkStrategyMap extends ModelBeanMap<SmartCampaignNetworkStrategyMap> {
    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public SmartCampaignNetworkStrategyMap() {
        super();
        setBean(new SmartCampaignNetworkStrategy());
    }

    public SmartCampaignNetworkStrategyMap(
            SmartCampaignNetworkStrategy smartCampaignNetworkStrategy) {
        super();
        setBean(smartCampaignNetworkStrategy);
    }

    public SmartCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignNetworkStrategyMap withBiddingStrategyType(
            SmartCampaignNetworkStrategyTypeEnum biddingStrategyType) {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public SmartCampaignNetworkStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
