package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.SmartCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

public class SmartCampaignSearchStrategyMap extends SmartCampaignStrategyBaseMap<SmartCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public SmartCampaignSearchStrategyMap() {
        super();
        setBean(new SmartCampaignSearchStrategy());
    }

    public SmartCampaignSearchStrategyMap(SmartCampaignSearchStrategy smartCampaignSearchStrategy) {
        super();
        setBean(smartCampaignSearchStrategy);
    }

    public SmartCampaignSearchStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignSearchStrategyMap withBiddingStrategyType(
            SmartCampaignSearchStrategyTypeEnum biddingStrategyType) {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public SmartCampaignSearchStrategyMap defaultAverageCpaPerCampaign() {
        return this.withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN)
                .withAverageCpaPerCampaign(
                        new StrategyAverageCpaPerCampaignMap().defaultStrategyAverageCpaPerCampaign(Currency.RUB));
    }


}
