package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.SmartCampaignSetting;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignSettingMap extends ModelBeanMap<SmartCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public SmartCampaignSettingMap() {
        super();
        setBean(new SmartCampaignSetting());
    }

    public SmartCampaignSettingMap(SmartCampaignSetting smartCampaignSetting) {
        super();
        setBean(smartCampaignSetting);
    }

    public SmartCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignSettingMap withOption(SmartCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public SmartCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
