package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaPerCampaignAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaPerFilterAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcPerCampaignAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcPerFilterAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageRoiAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyPayForConversionPerCampaignAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignStrategyAddBaseMap<T> extends ModelBeanMap<SmartCampaignStrategyAddBaseMap> {

    public static final String AVERAGE_CPC_PER_CAMPAIGN = "averageCpcPerCampaign";
    public static final String AVERAGE_CPC_PER_FILTER = "averageCpcPerFilter";
    public static final String AVERAGE_CPA_PER_CAMPAIGN = "averageCpaPerCampaign";
    public static final String AVERAGE_CPA_PER_FILTER = "averageCpaPerFilter";
    public static final String PAY_FOR_CONVERSION_PER_CAMPAIGN = "payForConversionPerCampaign";
    public static final String AVERAGE_ROI = "averageRoi";

    public SmartCampaignStrategyAddBaseMap() {
        super();
    }

    public T withAverageCpcPerCampaign(StrategyAverageCpcPerCampaignAddMap paramsMap) {
        StrategyAverageCpcPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerCampaignAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpcPerFilter(StrategyAverageCpcPerFilterAddMap paramsMap) {
        StrategyAverageCpcPerFilterAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerFilterAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageCpaPerCampaign(StrategyAverageCpaPerCampaignAddMap paramsMap) {
        StrategyAverageCpaPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerCampaignAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpaPerFilter(StrategyAverageCpaPerFilterAddMap paramsMap) {
        StrategyAverageCpaPerFilterAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerFilterAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiAddMap paramsMap) {
        StrategyAverageRoiAdd params =
                ((paramsMap == null) ? null : (StrategyAverageRoiAdd) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }

    public T withPayForConversionPerCampaign(StrategyPayForConversionPerCampaignAddMap paramsMap) {
        StrategyPayForConversionPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyPayForConversionPerCampaignAdd) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION_PER_CAMPAIGN, params);
        return (T) this;
    }
}
