package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.SmartCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignStrategyMap extends ModelBeanMap<SmartCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public SmartCampaignStrategyMap() {
        super();
        setBean(new SmartCampaignStrategy());
    }

    public SmartCampaignStrategyMap(SmartCampaignStrategy smartCampaignStrategy) {
        super();
        setBean(smartCampaignStrategy);
    }

    public SmartCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignStrategyMap withSearch(
            SmartCampaignSearchStrategyMap smartCampaignSearchStrategyMap) {
        SmartCampaignSearchStrategy smartCampaignSearchStrategy =
                ((smartCampaignSearchStrategyMap == null) ? null
                        : (SmartCampaignSearchStrategy) (smartCampaignSearchStrategyMap.getBean()));
        this.put(SEARCH, smartCampaignSearchStrategy);
        return this;
    }

    public SmartCampaignStrategyMap withNetwork(
            SmartCampaignNetworkStrategyMap smartCampaignNetworkStrategyMap) {
        SmartCampaignNetworkStrategy smartCampaignNetworkStrategy =
                ((smartCampaignNetworkStrategyMap == null) ? null
                        : (SmartCampaignNetworkStrategy) (smartCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, smartCampaignNetworkStrategy);
        return this;
    }

    public SmartCampaignStrategyMap defaultSmartCampaignStrategy() {
        return this
                .withSearch(new SmartCampaignSearchStrategyMap()
//                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN))
                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.SERVING_OFF))

                .withNetwork(new SmartCampaignNetworkStrategyMap()
//                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF));
                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPC_PER_CAMPAIGN));

    }
}
