package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsUpdateSetting;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignStrategy;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignUpdateItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

public class SmartCampaignUpdateItemMap extends SmartCampaignBaseMap<SmartCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public SmartCampaignUpdateItemMap() {
        super();
        setBean(new SmartCampaignUpdateItem());
    }

    public SmartCampaignUpdateItemMap(SmartCampaignUpdateItem smartCampaignUpdateItem) {
        super();
        setBean(smartCampaignUpdateItem);
    }

    public SmartCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignUpdateItemMap withBiddingStrategy(
            SmartCampaignStrategyMap smartCampaignStrategyMap) {
        SmartCampaignStrategy smartCampaignStrategy =
                ((smartCampaignStrategyMap == null) ? null
                        : (SmartCampaignStrategy) (smartCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, smartCampaignStrategy);
        return this;
    }

    public SmartCampaignUpdateItemMap withSettings(SmartCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public SmartCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateSettingMap priorityGoalsUpdateSettingMap) {
        PriorityGoalsUpdateSetting priorityGoalsUpdateSetting = (PriorityGoalsUpdateSetting)
                ((priorityGoalsUpdateSettingMap == null) ? null
                        : priorityGoalsUpdateSettingMap.getBean());
        JAXBElement<PriorityGoalsUpdateSetting> jaxbElement =
                new ObjectFactory().createSmartCampaignUpdateItemPriorityGoals(priorityGoalsUpdateSetting);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public SmartCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateItemMap... priorityGoalsUpdate) {
        PriorityGoalsUpdateSettingMap priorityUpdateSettingMap =
                (priorityGoalsUpdate == null) ? null :
                        new PriorityGoalsUpdateSettingMap().withItems(priorityGoalsUpdate);
        return this.withPriorityGoals(priorityUpdateSettingMap);
    }
}
