package ru.yandex.autotests.directapi.model.api5.campaignsext;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaignsext.SmsEventsEnum;
import com.yandex.direct.api.v5.campaignsext.SmsSettings;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class SmsSettingsMap extends ModelBeanMap<SmsSettingsMap> {

    public static final String EVENTS = "events";
    public static final String TIME_FROM = "timeFrom";
    public static final String TIME_TO = "timeTo";

    public static final String VALID_TIME_FROM = "12:00";
    public static final String VALID_TIME_TO = "15:00";

    public static final String DEFAULT_TIME_FROM = "00:00";
    public static final String DEFAULT_TIME_TO = "00:00";

    public SmsSettingsMap() {
        super();
        setBean(new SmsSettings());
    }

    public SmsSettingsMap(SmsSettings smsSettings) {
        super();
        setBean(smsSettings);
    }

    public SmsSettingsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmsSettingsMap withEvents(SmsEventsEnum... events) {
        this.put(EVENTS, Arrays.asList(events));
        return this;
    }

    public SmsSettingsMap withTimeFrom(String timeFrom) {
        this.put(TIME_FROM, timeFrom);
        return this;
    }

    public SmsSettingsMap withTimeTo(String timeTo) {
        this.put(TIME_TO, timeTo);
        return this;
    }

    public SmsSettingsMap defaultSmsSettings() {
        return this.withTimeFrom(VALID_TIME_FROM).withTimeTo(VALID_TIME_TO);
    }
}
