package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 31.08.15.
 */
public class StrategyAverageCpaAddMap extends ModelBeanMap<StrategyAverageCpaAddMap> {

    public static final String AVERAGE_CPA = "averageCpa";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyAverageCpaAddMap() {
        super();
        setBean(new StrategyAverageCpaAdd());
    }

    public StrategyAverageCpaAddMap(StrategyAverageCpaAdd strategyAverageCpaAdd) {
        super();
        setBean(strategyAverageCpaAdd);
    }

    public StrategyAverageCpaAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaAddMap defaultStrategyAverageCpa(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withAverageCpa(averagePrice.bidLong().longValue());
    }

    public StrategyAverageCpaAddMap withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }

    public StrategyAverageCpaAddMap withAverageCpa(Long averageCpa) {
        this.put(AVERAGE_CPA, averageCpa);
        return this;
    }

    public StrategyAverageCpaAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }

    public StrategyAverageCpaAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
