package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpa;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyAverageCpaMap extends ModelBeanMap<StrategyAverageCpaMap> {

    public static final String AVERAGE_CPA = "averageCpa";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyAverageCpaMap() {
        super();
        setBean(new StrategyAverageCpa());
    }

    public StrategyAverageCpaMap(StrategyAverageCpa strategyAverageCpa) {
        super();
        setBean(strategyAverageCpa);
    }

    public StrategyAverageCpaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaMap defaultStrategyAverageCpa(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpa(averagePrice.bidLong().longValue())
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpaMap withAverageCpa(Long averageCpa) {
        this.put(AVERAGE_CPA, averageCpa);
        return this;
    }

    public StrategyAverageCpaMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }

    public StrategyAverageCpaMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
