package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaPerCampaignAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

@ParametersAreNonnullByDefault
public class StrategyAverageCpaPerCampaignAddMap extends ModelBeanMap<StrategyAverageCpaPerCampaignAddMap> {
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpaPerCampaignAddMap() {
        super();
        setBean(new StrategyAverageCpaPerCampaignAdd());
    }

    public StrategyAverageCpaPerCampaignAddMap(StrategyAverageCpaPerCampaignAdd strategyAverageCpaPerCampaignAdd) {
        super();
        setBean(strategyAverageCpaPerCampaignAdd);
    }

    public StrategyAverageCpaPerCampaignAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap defaultStrategyAverageCpaPerCampaignAdd(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpa(averagePrice.bidLong().longValue() * 10L)
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerCampaignAddMap withAverageCpa(Long averageCpa) {
        this.put(AVERAGE_CPA, averageCpa);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerCampaignBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerCampaignWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
