package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaPerCampaign;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyAverageCpaPerCampaignMap extends ModelBeanMap<StrategyAverageCpaPerCampaignMap> {
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpaPerCampaignMap() {
        super();
        setBean(new StrategyAverageCpaPerCampaign());
    }

    public StrategyAverageCpaPerCampaignMap(StrategyAverageCpaPerCampaign strategyAverageCpaPerCampaign) {
        super();
        setBean(strategyAverageCpaPerCampaign);
    }

    public StrategyAverageCpaPerCampaignMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap defaultStrategyAverageCpaPerCampaign(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpa(averagePrice.bidLong().longValue() * 10L)
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerCampaignMap withAverageCpa(Long averageCpa) {
        this.put(AVERAGE_CPA, averageCpa);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerCampaignBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerCampaignWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
