package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 05.08.15.
 */
public class StrategyAverageCpcAddMap extends ModelBeanMap<StrategyAverageCpcAddMap> {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpcAddMap() {
        super();
        setBean(new StrategyAverageCpcAdd());
    }

    public StrategyAverageCpcAddMap(StrategyAverageCpcAdd strategyAverageCpcAdd) {
        super();
        setBean(strategyAverageCpcAdd);
    }

    public StrategyAverageCpcAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpcAddMap defaultStrategyAverageCpc(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withAverageCpc(averagePrice.bidLong().longValue());
    }

    public StrategyAverageCpcAddMap withAverageCpc(Long averageCpc) {
        this.put(AVERAGE_CPC, averageCpc);
        return this;
    }

    public StrategyAverageCpcAddMap withWeeklySpendLimit(Long weeklyLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklyLimit);
        return this;
    }
}
