package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpc;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyAverageCpcMap extends ModelBeanMap<StrategyAverageCpcMap> {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpcMap() {
        super();
        setBean(new StrategyAverageCpc());
    }

    public StrategyAverageCpcMap(StrategyAverageCpc strategyAverageCpc) {
        super();
        setBean(strategyAverageCpc);
    }

    public StrategyAverageCpcMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpcMap defaultStrategyAverageCpc(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpc(averagePrice.bidLong().longValue())
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcMap withAverageCpc(Long averageCpc) {
        this.put(AVERAGE_CPC, averageCpc);
        return this;
    }

    public StrategyAverageCpcMap withWeeklySpendLimit(Long weeklyLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcWeeklySpendLimit(weeklyLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
