package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcPerCampaign;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyAverageCpcPerCampaignMap extends ModelBeanMap<StrategyAverageCpcPerCampaignMap> {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";

    public StrategyAverageCpcPerCampaignMap() {
        super();
        setBean(new StrategyAverageCpcPerCampaign());
    }

    public StrategyAverageCpcPerCampaignMap(StrategyAverageCpcPerCampaign strategyAverageCpcPerCampaign) {
        super();
        setBean(strategyAverageCpcPerCampaign);
    }

    public StrategyAverageCpcPerCampaignMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpcPerCampaignMap defaultStrategyAverageCpcPerCampaign(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpc(averagePrice.bidLong().longValue())
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerCampaignMap withAverageCpc(Long averageCpc) {
        this.put(AVERAGE_CPC, averageCpc);
        return this;
    }

    public StrategyAverageCpcPerCampaignMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcPerCampaignBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpcPerCampaignMap withWeeklySpendLimit(Long weeklyLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcWeeklySpendLimit(weeklyLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
