package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageRoi;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyAverageRoiMap extends ModelBeanMap<StrategyAverageRoiMap> {

    public static final String RESERVE_RETURN = "reserveReturn";
    public static final String ROI_COEF = "roiCoef";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String PROFITABILITY = "profitability";

    public static final Long MIN_PROFITABILITY = 0L; //0
    public static final Long MAX_PROFITABILITY = 100000000L; //100
    public static final Integer MIN_RESERVE_RETURN = 0;
    public static final Integer MAX_RESERVE_RETURN = 100;
    public static final Long MIN_ROI_COEF = -990000L; //-0.99

    public static final Long DEFAULT_PROFITABILITY = 2000000L;
    public static final Integer DEFAULT_RESERVE_RETURN = 10;
    public static final Long DEFAULT_ROI_COEF = 1000000L;

    public StrategyAverageRoiMap() {
        super();
        setBean(new StrategyAverageRoi());
    }

    public StrategyAverageRoiMap(StrategyAverageRoi strategyAverageRoi) {
        super();
        setBean(strategyAverageRoi);
    }

    public StrategyAverageRoiMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageRoiMap defaultStrategyAverageRoi() {
        return this
                .withReserveReturn(DEFAULT_RESERVE_RETURN)
                .withRoiCoef(DEFAULT_ROI_COEF);
    }

    public StrategyAverageRoiMap withReserveReturn(Integer reserveReturn) {
        this.put(RESERVE_RETURN, reserveReturn);
        return this;
    }

    public StrategyAverageRoiMap withRoiCoef(Long roiCoef) {
        this.put(ROI_COEF, roiCoef);
        return this;
    }

    public StrategyAverageRoiMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageRoiMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageRoiWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }

    public StrategyAverageRoiMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageRoiBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageRoiMap withProfitability(Long profitability) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageRoiProfitability(profitability);
        this.put(PROFITABILITY, jaxbElement);
        return this;
    }
}
