package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyCpMaximumImpressions;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;

/**
 * Created by gerdler on 08.09.18.
 */
public class StrategyCpMaximumImpressionsMap extends StrategyMaximizeImpressionsBaseMap<StrategyCpMaximumImpressionsMap> {

    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String AUTO_CONTINUE = "autoContinue";

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public StrategyCpMaximumImpressionsMap() {
        super();
        setBean(new StrategyCpMaximumImpressions());
    }

    public StrategyCpMaximumImpressionsMap(StrategyCpMaximumImpressions strategyCpMaximumImpressions) {
        super();
        setBean(strategyCpMaximumImpressions);
    }

    public StrategyCpMaximumImpressionsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyCpMaximumImpressionsMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public StrategyCpMaximumImpressionsMap withEndDate(String endDate) {
        this.put(END_DATE, endDate);
        return this;
    }

    public StrategyCpMaximumImpressionsMap withAutoContinue(YesNoEnum autoContinue) {
        this.put(AUTO_CONTINUE, autoContinue);
        return this;
    }

    public StrategyCpMaximumImpressionsMap withDefaultCpMaximumImpressions(Long averageCpm, Long spendLimit) {
        this.withDefaultMaximumImpressions(averageCpm, spendLimit);
        this.put(START_DATE, DateTime.now().toString(DATE_PATTERN));
        this.put(END_DATE, DateTime.now().plusDays(1).toString(DATE_PATTERN));
        this.put(AUTO_CONTINUE, YesNoEnum.NO);
        return this;
    }
}
