package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyMaximumAppInstallsAdd;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 24.09.15.
 */
public class StrategyMaximumAppInstallsAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumAppInstallsAddMap> {

    public StrategyMaximumAppInstallsAddMap() {
        super();
        setBean(new StrategyMaximumAppInstallsAdd());
    }

    public StrategyMaximumAppInstallsAddMap(StrategyMaximumAppInstallsAdd strategyMaximumAppInstallsAdd) {
        super();
        setBean(strategyMaximumAppInstallsAdd);
    }

    public StrategyMaximumAppInstallsAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumAppInstallsAddMap defaultStrategyMaximumAppInstalls(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this.withWeeklySpendLimit(weeklyBudget.bidLong().longValue());
    }
}
