package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyMaximumConversionRateAdd;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by chicos on 31.08.15.
 */
public class StrategyMaximumConversionRateAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumConversionRateAddMap> {

    public static final String GOAL_ID = "goalId";

    public StrategyMaximumConversionRateAddMap() {
        super();
        setBean(new StrategyMaximumConversionRateAdd());
    }

    public StrategyMaximumConversionRateAddMap(StrategyMaximumConversionRateAdd strategyMaximumConversionRateAdd) {
        super();
        setBean(strategyMaximumConversionRateAdd);
    }

    public StrategyMaximumConversionRateAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumConversionRateAddMap defaultMaximumConversionRateParams(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this.withWeeklySpendLimit(weeklyBudget.bidLong().longValue());
    }

    public StrategyMaximumConversionRateAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
