package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyMaximumConversionRate;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyMaximumConversionRateMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumConversionRateMap> {

    public static final String GOAL_ID = "goalId";

    public StrategyMaximumConversionRateMap() {
        super();
        setBean(new StrategyMaximumConversionRate());
    }

    public StrategyMaximumConversionRateMap(StrategyMaximumConversionRate strategyMaximumConversionRate) {
        super();
        setBean(strategyMaximumConversionRate);
    }

    public StrategyMaximumConversionRateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumConversionRateMap defaultMaximumConversionRateParams(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this
                .withWeeklySpendLimit(weeklyBudget.bidLong().longValue())
                .withBidCeiling(null);
    }

    public StrategyMaximumConversionRateMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
