package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyNetworkDefaultAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class StrategyNetworkDefaultAddMap extends ModelBeanMap<StrategyNetworkDefaultAddMap> {
    public static final String LIMIT_PERCENT = "limitPercent"; //old ContextLimitSum

    public static final Integer TEST_LIMIT_PERCENT = 30;

    public static final Integer DEFAULT_LIMIT_PERCENT = 100;

    public StrategyNetworkDefaultAddMap() {
        super();
        setBean(new StrategyNetworkDefaultAdd());
    }

    public StrategyNetworkDefaultAddMap(StrategyNetworkDefaultAdd networkDefaultParams) {
        super();
        setBean(networkDefaultParams);
    }

    public StrategyNetworkDefaultAddMap defaultStrategyNetworkDefault() {
        return this.withLimitPercent(TEST_LIMIT_PERCENT);
    }

    public StrategyNetworkDefaultAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyNetworkDefaultAddMap withLimitPercent(Integer limitPercent) {
        this.put(LIMIT_PERCENT, limitPercent);
        return this;
    }
}
