package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyPayForConversionPerCampaign;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pashkus on 25.05.20.
 */
public class StrategyPayForConversionPerCampaignMap extends ModelBeanMap<StrategyPayForConversionPerCampaignMap> {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionPerCampaignMap() {
        super();
        setBean(new StrategyPayForConversionPerCampaign());
    }

    public StrategyPayForConversionPerCampaignMap(StrategyPayForConversionPerCampaign strategyPayForConversion) {
        super();
        setBean(strategyPayForConversion);
    }

    public StrategyPayForConversionPerCampaignMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionPerCampaignMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withCpa(minCpa.bidLong().longValue())
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionPerCampaignMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionPerCampaignMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForConversionPerCampaignWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }

    public StrategyPayForConversionPerCampaignMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
