package ru.yandex.autotests.directapi.model.api5.campaignsext;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyWeeklyBudgetAddBaseMap<T> extends ModelBeanMap<StrategyWeeklyBudgetAddBaseMap> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyWeeklyBudgetAddBaseMap() {
        super();
    }

    public T withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return (T) this;
    }

    public T withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return (T) this;
    }
}
