package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackage;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyWeeklyClickPackageMap extends ModelBeanMap<StrategyWeeklyClickPackageMap> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String CLICKS_PER_WEEK = "clicksPerWeek";

    public static final Long DEFAULT_CLICKS_PER_WEEK = 1000L;
    public static final Long MIN_CLICKS_PER_WEEK = 100L;

    public StrategyWeeklyClickPackageMap() {
        super();
        setBean(new StrategyWeeklyClickPackage());
    }

    public StrategyWeeklyClickPackageMap(StrategyWeeklyClickPackage strategyWeeklyClickPackage) {
        super();
        setBean(strategyWeeklyClickPackage);
    }

    public StrategyWeeklyClickPackageMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyWeeklyClickPackageMap defaultStrategyWeeklyClickPackage() {
        return this
                .withClicksPerWeek(DEFAULT_CLICKS_PER_WEEK)
                .withBidCeiling(null)
                .withAverageCpc(null);
    }

    public StrategyWeeklyClickPackageMap withBidCeiling(Long bidCeling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyWeeklyClickPackageBidCeiling(bidCeling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyWeeklyClickPackageMap withClicksPerWeek(Long clicksPerWeek) {
        this.put(CLICKS_PER_WEEK, clicksPerWeek);
        return this;
    }

    public StrategyWeeklyClickPackageMap withAverageCpc(Long averagePrice) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyWeeklyClickPackageAverageCpc(averagePrice);
        this.put(AVERAGE_CPC, jaxbElement);
        return this;
    }
}
