package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsArray;
import com.yandex.direct.api.v5.campaignsext.TextCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.TextCampaignStrategy;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 26.08.15.
 */
public class TextCampaignGetItemMap extends TextCampaignBaseMap<TextCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public TextCampaignGetItemMap() {
        setBean(new TextCampaignGetItem());
    }

    public TextCampaignGetItemMap(TextCampaignGetItem textCampaignGetItem) {
        super();
        setBean(textCampaignGetItem);
    }

    public TextCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignGetItemMap withBiddingStrategy(TextCampaignStrategyMap textCampaignStrategyAddMap) {
        TextCampaignStrategy textCampaignStrategy =
                ((textCampaignStrategyAddMap == null) ? null
                        : (TextCampaignStrategy) (textCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, textCampaignStrategy);
        return this;
    }

    public TextCampaignGetItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoalsArray = (PriorityGoalsArray)
                ((priorityGoalsArrayMap == null) ? null
                        : priorityGoalsArrayMap.getBean());
        JAXBElement<PriorityGoalsArray> jaxbElement =
                new ObjectFactory().createTextCampaignGetItemPriorityGoals(priorityGoalsArray);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public TextCampaignGetItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        PriorityGoalsArrayMap priorityGoalsArray =
                (priorityGoals == null) ? null : new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(priorityGoalsArray);
    }

    public TextCampaignGetItemMap withSettings(TextCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public TextCampaignGetItemMap defaultTextCampaign() {
        return this.withBiddingStrategy(new TextCampaignStrategyMap().defaultTextCampaignStrategy());
    }
}
