package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyNetworkDefaultAdd;
import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignNetworkStrategyAddMap extends TextCampaignStrategyAddBaseMap<TextCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String NETWORK_DEFAULT = "networkDefault";

    public TextCampaignNetworkStrategyAddMap() {
        super();
        setBean(new TextCampaignNetworkStrategyAdd());
    }

    public TextCampaignNetworkStrategyAddMap(TextCampaignNetworkStrategyAdd textCampaignNetworkStrategy) {
        super();
        setBean(textCampaignNetworkStrategy);
    }

    public TextCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignNetworkStrategyAddMap withNetworkDefault(
            StrategyNetworkDefaultAddMap StrategyNetworkDefaultAddMap)
    {
        StrategyNetworkDefaultAdd networkDefaultParams =
                ((StrategyNetworkDefaultAddMap == null) ? null
                        : (StrategyNetworkDefaultAdd) (StrategyNetworkDefaultAddMap.getBean()));
        this.put(NETWORK_DEFAULT, networkDefaultParams);
        return this;
    }

    public TextCampaignNetworkStrategyAddMap withBiddingStrategyType(
            TextCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public TextCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public TextCampaignNetworkStrategyAddMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public TextCampaignNetworkStrategyAddMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap());
    }

    public TextCampaignNetworkStrategyAddMap defaultNetworkDefaultWithLimitPercent() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap().defaultStrategyNetworkDefault());
    }

    public TextCampaignNetworkStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public TextCampaignNetworkStrategyAddMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaAddMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiAddMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
