package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyNetworkDefault;
import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class TextCampaignNetworkStrategyMap extends TextCampaignStrategyBaseMap<TextCampaignNetworkStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String NETWORK_DEFAULT = "networkDefault";

    public TextCampaignNetworkStrategyMap() {
        super();
        setBean(new TextCampaignNetworkStrategy());
    }

    public TextCampaignNetworkStrategyMap(TextCampaignNetworkStrategy textCampaignNetworkStrategy) {
        super();
        setBean(textCampaignNetworkStrategy);
    }

    public TextCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignNetworkStrategyMap withNetworkDefault(StrategyNetworkDefaultMap strategyNetworkDefaultMap) {
        StrategyNetworkDefault networkDefaultParams =
                ((strategyNetworkDefaultMap == null) ? null
                        : (StrategyNetworkDefault) (strategyNetworkDefaultMap.getBean()));
        this.put(NETWORK_DEFAULT, networkDefaultParams);
        return this;
    }

    public TextCampaignNetworkStrategyMap withBiddingStrategyType(
            TextCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public TextCampaignNetworkStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public TextCampaignNetworkStrategyMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public TextCampaignNetworkStrategyMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultMap());
    }

    public TextCampaignNetworkStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public TextCampaignNetworkStrategyMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public TextCampaignNetworkStrategyMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
