package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.TextCampaignSetting;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignSettingMap extends ModelBeanMap<TextCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public TextCampaignSettingMap() {
        super();
        setBean(new TextCampaignSetting());
    }

    public TextCampaignSettingMap(TextCampaignSetting textCampaignSetting) {
        super();
        setBean(textCampaignSetting);
    }

    public TextCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignSettingMap withOption(TextCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public TextCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
